#include "h/wav.h"

void readWAVHeader(WAVHeader* header, BYTE* input)
{
	// extract WAV Header information from input stream
	void* inputPtr;

	inputPtr=(void*)input;
	header->riff=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+4);
	header->chunkSize=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+8);
	header->format=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+12);
	header->subChunk1ID=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+16);
	header->subChunk1Size=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+20);
	header->audioFormat=*(unsigned int*)inputPtr;
	inputPtr=(void*)(input+22);
	header->numChannels=*(unsigned int*)inputPtr;
	inputPtr=(void*)(input+24);
	header->sampleRate=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+28);
	header->byteRate=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+32);
	header->blockAlign=*(unsigned int*)inputPtr;
	inputPtr=(void*)(input+34);
	header->bitsPerSample=*(unsigned int*)inputPtr;
	inputPtr=(void*)(input+36);
	header->subChunk2ID=*(unsigned long*)inputPtr;
	inputPtr=(void*)(input+40);
	header->subChunk2Size=*(unsigned long*)inputPtr;
}

void writeWAVHeader(WAVHeader* header, BYTE* output)
{
	// write WAV Header information to output stream
	void* outputPtr;
	outputPtr=(void*)output;
	*(unsigned long*)outputPtr=header->riff;		// RIFF
	outputPtr=(void*)(output+4);
	*(unsigned long*)outputPtr=header->chunkSize;
	outputPtr=(void*)(output+8);
	*(unsigned long*)outputPtr=header->format;		// WAVE
	outputPtr=(void*)(output+12);
	*(unsigned long*)outputPtr=header->subChunk1ID;	// fmt
	outputPtr=(void*)(output+16);
	*(unsigned long*)outputPtr=header->subChunk1Size;
	outputPtr=(void*)(output+20);
	*(unsigned int*)outputPtr=header->audioFormat;
	outputPtr=(void*)(output+22);
	*(unsigned int*)outputPtr=header->numChannels;
	outputPtr=(void*)(output+24);
	*(unsigned long*)outputPtr=header->sampleRate;
	outputPtr=(void*)(output+28);
	*(unsigned long*)outputPtr=header->byteRate;
	outputPtr=(void*)(output+32);
	*(unsigned int*)outputPtr=header->blockAlign;
	outputPtr=(void*)(output+34);
	*(unsigned int*)outputPtr=header->bitsPerSample;
	outputPtr=(void*)(output+36);
	*(unsigned long*)outputPtr=header->subChunk2ID;
	outputPtr=(void*)(output+40);
	*(unsigned long*)outputPtr=header->subChunk2Size;
}

void fillWAVHeader(WAVHeader* header)
{
	// fills some constants
	header->riff=0x46464952;				// RIFF
	header->format=0x45564157;				// WAVE
	header->subChunk1ID=0x20746d66;			// fmt
	header->subChunk1Size=16;
	header->subChunk2ID=0x61746164;			// data
}
